#ifndef GLOBAL_H
#define GLOBAL_H

#include <rpskin.h>
#include "material.h"
#include "blind.h"
#include <list>

using namespace std;

typedef enum
{
    SCALEBY = 0,
    SCALETO
}
ScaleType;

typedef enum 
{ 
    LOCAL = 0,
    WORLD
}
CoordSystem;

typedef enum
{
    TRISTRIP_DEFAULT = 1,
    TRISTRIP_PREPROCESS,
    TRISTRIP_EXHAUSTIVE
}
TriStripper;

/*
    Nasty lists used in dffexp.cpp. This information needs to be pulled
    into the scene class.
*/

typedef struct __skinClusterList _skinClusterList;

struct __skinClusterList
{
    MFnSkinCluster      *skinCluster;
    MDagPath            *skin;
    MDagPathArray       *joints;
    _skinClusterList    *next;
};

typedef struct __ikHandleList _ikHandleList;

struct __ikHandleList
{    
    MDagPath        *startJoint;
    MDagPath        *endEffector;
    MObject         *handle;
    _ikHandleList   *next;
};

typedef struct __dagPathBoneIndexList _dagPathBoneIndexList;

struct __dagPathBoneIndexList
{
    int                     index;
    MDagPath                *object;
    _dagPathBoneIndexList   *next;
};


/* Class to store data global across the export process */
class GlobalData
{
public:
    GlobalData();

    /* Shared Export Data */
    float           m_scaleFactor;
    bool            m_textureNameWarning;
    bool            m_verbose;
    bool            m_triStrips;
    TriStripper     m_triStripper;
    bool            m_exportNormals;
    bool            m_limitUVs;
    float           m_uvLimit;
    MaterialMap     *materialMap;
    int             selectedMdtShape;
    bool            underSelectedMdtShape;

    /* DFF Export Data */
    ScaleType       m_scaleType;
    CoordSystem     m_coordinateSystem;
    bool            m_preLight;
    bool            m_morphTargets;
    bool            m_morphSampleNotKeys;
    int             m_morphTargetInterval;
    bool            m_animSeq;
    bool            m_exportKL;
    bool            m_dynamicKeyframeGeneration;
    float           m_keyframeGenerationTolerance;
    int             m_animStart;
    int             m_animEnd;
    int             m_animLength;
    char            *m_defaultAnimName;
    bool            m_optimiseHierarchy;
    bool            m_cullDff;

    bool            m_exportRpAnim;
    bool            m_exportRpSkin;
    bool            m_exportRpSkinWeighting;
    bool            m_exportRpHAnim;
    bool            m_rpHAnimSubHierarchy;
    bool            m_rpHAnimLocalMatrices;
    bool            m_rpHAnimNoMatrices;

    _skinClusterList        *gSkinClusterList;
    _ikHandleList           *gIkHandleList;
    _dagPathBoneIndexList   *gDagPathBoneIndexList;

    blindDataTemplateList  blindDataTemplates;

    int         hierarchyRootShape;
    RwFrame     *hierarchyRootFrame;
    RpAtomic    *skinAtomic;
    int         currentBoneIndex;
    RwInt32     *vertexMap;

    /* BSP Export Data */
    int             m_maxPolysPerSector;
    float           m_maxSectorSize;
	float			m_weldThreshold;
	int				m_maxClosestCheck;
    bool            m_preLightWorld;
    float           m_maxSectorOverlap;
    bool            m_noAlphaInOverlap;
    bool            m_generateCollision;
    blindData       *worldBlindData;
    int             *blindDataRemap;
    blindDataSectorRemapList sectorMap;
};

extern GlobalData *globalData;

#endif /* GLOBAL_H */